# This code firstly generates the raster maps for the weibull parameters and then disaggregate the total volume per pixel using the estimated
# voloume diameter distribution

#========================================================================================================================================
# 1 - Parameters spatialisation (the parameter were estimated in Matlabm EstPar.csv, the matlab code is in the supplementary material)
#========================================================================================================================================

#inputs required
# 1) Weibull estimated parameters for each silvoecoregion SER (EstPas.csv)
# 2) The SER map (ser_final.tif)

rm(list = ls())

library(raster)
library(rgdal)
library(ggplot2)
library(sp)

#estimated parameters repository
par_dir <- c("~/MATLAB/Chalara/")
ser_dir <- c("~/LEF/Dottorato/Case_studies/Chalara/Data/SER/")

Wpar <- read.csv(paste0(par_dir,"EstPar.csv"))


ser<-raster(paste0(ser_dir,"ser_final.tif"))


m <-c(4,101,5,101,21,101,24,101,40,101,42,102,45,102,46,102,47,102,62,103,74,103,
      77,104,78,104,79,104,28,30,71,69,55,54,80,105,81,105,82,105,83,105)
rclmat <- matrix(m, ncol=2, byrow=TRUE)
ser <- reclassify(ser, rclmat)


writeRaster(ser, filename="~/LEF/Dottorato/Case_studies/Chalara/Data/Ash_distribution/FFSM_input/Kriging/Results/Disaggregate/newser.tif", format="GTiff", overwrite=TRUE)




# set NA values to -9999
funNA <- function(x) { x[is.na(x)] <- -9999; return(x)} 
ser <- calc(ser, funNA)

#scale parameters
scale<-ser
values(scale)=0
scaleser<-stack(ser,scale)
names(scaleser) <- c('ser','scale')




#assign to each cell the scale parameter
for(i in list( 1 ,  2 ,  3 ,  6 ,  7  , 8 ,  9 , 10  ,11 , 12 , 13 ,
               14 , 15 , 16 , 17 , 18 , 19 , 20 , 22 , 23 , 25 , 26 , 27 ,
               29 , 30 , 31 , 32  ,33 , 34 , 35 , 36 , 37 , 38 , 39 , 41,  43,
               44 , 48 , 49 , 50 , 51 , 52  ,53  ,54 , 56 , 57 , 58  ,59 ,
               60 , 61 , 63  ,64 , 65 , 66 , 67 , 68,  69,  70 , 72 , 73 , 75,
               76 ,101, 102 ,103 ,104, 105)) {
  fun_scale <- function(x,ser=i,par=Wpar$Scale[which(Wpar$newser == i)]) { if(x[1]==ser) x[2] <- par else {}; return(x) }
  scaleser <- calc(scaleser, fun_scale)
}

scaleser$scale[ser==-9999]=NA


scale<-scaleser$scale
plot(scale)

writeRaster(scale, filename="~/LEF/Dottorato/Case_studies/Chalara/Data/Ash_distribution/FFSM_input/Kriging/Results/Disaggregate/scale.asc", format="ascii", overwrite=TRUE)

writeRaster(scale, filename="~/LEF/Dottorato/Case_studies/Chalara/Data/Ash_distribution/FFSM_input/Kriging/Results/Disaggregate/scale.tif", format="GTiff", overwrite=TRUE)





#========================================================================================== 
#shape parameters
shape<-ser
values(shape)=0
shapeser<-stack(ser,shape)
names(shapeser) <- c('ser','shape')


#assign to each cell the shape parameter
for(i in list( 1 ,  2 ,  3 ,  6 ,  7  , 8 ,  9 , 10  ,11 , 12 , 13 ,
               14 , 15 , 16 , 17 , 18 , 19 , 20 , 22 , 23 , 25 , 26 , 27 ,
               29 , 30 , 31 , 32  ,33 , 34 , 35 , 36 , 37 , 38 , 39 , 41,  43,
               44 , 48 , 49 , 50 , 51 , 52  ,53  ,54 , 56 , 57 , 58  ,59 ,
               60 , 61 , 63  ,64 , 65 , 66 , 67 , 68,  69,  70 , 72 , 73 , 75,
               76 ,101, 102 ,103 ,104, 105))  {
  fun_scale <- function(x,ser=i,par=Wpar$Shape[which(Wpar$newser == i)]) { if(x[1]==ser) x[2] <- par else {}; return(x) }
  shapeser <- calc(shapeser, fun_scale)
}



shapeser$shape[ser==-9999]=NA


shape<-shapeser$shape
plot(shape)

writeRaster(shape, filename="~/LEF/Dottorato/Case_studies/Chalara/Data/Ash_distribution/FFSM_input/Kriging/Results/Disaggregate/shape.asc", format="ascii", overwrite=TRUE)
writeRaster(shape, filename="~/LEF/Dottorato/Case_studies/Chalara/Data/Ash_distribution/FFSM_input/Kriging/Results/Disaggregate/shape.tif", format="GTiff", overwrite=TRUE)



#==========================================================================================================================================
#==========================================================================================================================================
# 2 - Volume disaggregation
#==========================================================================================================================================

#This code disaggregate the total volume in each cell (obtained by kriging with external drift)
#and disaggregate it in each diameter class of FFSM. The disaggregation is done using
#the 3-parameter Weibull cdf parameters estimated in Matlab. The vol9 is aggregated to vol1
#since it is the closes class in terms of species and structure characteristics

# inputs
# 1) The output from ash_volume_paper with the total ash volume per pixel (vol1-vol9)
# 2) The output from section 1 of this script (newser.tif and Disagr.csv)


#======== KED SER ===============================================================
rm(list = ls())

library(FAdist)
library(raster)
library(rgdal)
library(ggplot2)
library(sp)
library(ncdf)

#inputs (include here the output from the ash_volume_paper script and from the section 1 of this script)
Wpar <- read.csv("~/MATLAB/Chalara/Disagr.csv")
ser<-raster("~/LEF/Dottorato/Case_studies/Chalara/Data/Ash_distribution/FFSM_input/Kriging/Results/Disaggregate/newser.tif")
vol1<-raster("~/LEF/Dottorato/Case_studies/Chalara/Data/Ash_distribution/FFSM_input/Kriging/Results/Output_ked/vol1.tif")
vol2<-raster("~/LEF/Dottorato/Case_studies/Chalara/Data/Ash_distribution/FFSM_input/Kriging/Results/Output_ked/vol2.tif")
vol3<-raster("~/LEF/Dottorato/Case_studies/Chalara/Data/Ash_distribution/FFSM_input/Kriging/Results/Output_ked/vol3.tif")
vol5<-raster("~/LEF/Dottorato/Case_studies/Chalara/Data/Ash_distribution/FFSM_input/Kriging/Results/Output_ked/vol5.tif")
vol9<-raster("~/LEF/Dottorato/Case_studies/Chalara/Data/Ash_distribution/FFSM_input/Kriging/Results/Output_ked/vol9.tif")



#generate empty rasters for each diameter class: dClasses      15     25 	  35 	  45 	  55 	  65 	  75 	  85 	  95 	  150
util<-ser
values(util)=0
for(i in 1:10){
  assign(paste("dc", 5+i*10, sep = ""), util)
}

# set NA values to -9999
funNA <- function(x) { x[is.na(x)] <- -9999; return(x)} 
ser <- calc(ser, funNA)



#------------- assign to each cell (homogeneour per SER) the share of volume per diameter class ------------------

dclasses<-stack(ser,dc15,dc25,dc35,dc45,dc55,dc65,dc75,dc85,dc95,dc105)
ser.list<-unique(Wpar$newser)

for(i in 1:10){prova=i}


for(j in 1:10) {
  perc=Wpar[j] #set the diam class of reference
  k=1
  for(i in ser.list){
    #for each ser, assign the value of the percentage of the selected diam class
    fun_prob <- function(x,ser=i,par=perc[k,1]) { if(x[[1]]==ser) x[[j+1]] <- par else {}; return(x) }
    dclasses <- calc(dclasses, fun_prob)
    k=k+1
  }
}



names(dclasses) <- c('ser','dc15','dc25','dc35','dc45','dc55','dc65','dc75','dc85','dc95','dc150')

dclasses$dc15[ser==-9999]=NA
dclasses$dc25[ser==-9999]=NA
dclasses$dc35[ser==-9999]=NA
dclasses$dc45[ser==-9999]=NA
dclasses$dc55[ser==-9999]=NA
dclasses$dc65[ser==-9999]=NA
dclasses$dc75[ser==-9999]=NA
dclasses$dc85[ser==-9999]=NA
dclasses$dc95[ser==-9999]=NA
dclasses$dc150[ser==-9999]=NA


writeRaster(dclasses, "~/LEF/Dottorato/Case_studies/Chalara/Data/Ash_distribution/FFSM_input/Kriging/Results/Disaggregate/perc_dclass.tif", format="GTiff", bylayer=TRUE, overwrite=TRUE)







#---------- multiply total volumes by diameter classes percentages -----------------
vol1<-vol1+vol9
vol1[vol1<0]<-0

vol2[vol2<0]<-0
vol3[vol3<0]<-0
vol5[vol5<0]<-0


vol<-stack(vol1,vol2,vol3,vol5)
names(vol)<-c("b_hf", "b_hfcp", "b_cp", "c" )

util<-vol1
values(util)=0


#generate empty rasters and then create raster stacks
for (name in c("b_hf", "b_hfcp", "b_cp", "c" )){
  for(i in 1:10){
    assign(paste(paste(name, "", sep = ""), 5+i*10, sep = ""), util)
  }
}

b_hf.stack<-stack(b_hf15,b_hf25,b_hf35,b_hf45,b_hf55,b_hf65,b_hf75,b_hf85,b_hf95,b_hf105)
b_hfcp.stack<-stack(b_hfcp15,b_hfcp25,b_hfcp35,b_hfcp45,b_hfcp55,b_hfcp65,b_hfcp75,b_hfcp85,b_hfcp95,b_hfcp105)
b_cp.stack<-stack(b_cp15,b_cp25,b_cp35,b_cp45,b_cp55,b_cp65,b_cp75,b_cp85,b_cp95,b_cp105)
c.stack<-stack(c15,c25,c35,c45,c55,c65,c75,c85,c95,c105)





#broadleaves high forest  
v=vol$b_hf

for(i in 1:10){
  b_hf.stack[[i]] <- v*dclasses[[i]]
}


#broadleaves high forest & coppice 
v=vol$b_hfcp

for(i in 1:10){
  b_hfcp.stack[[i]] <- v*dclasses[[i]]
}


#broadleaves  coppice 
v=vol$b_cp

for(i in 1:10){
  b_cp.stack[[i]] <- v*dclasses[[i]]
}


#broadleaves high forest & coppice 
v=vol$c

for(i in 1:10){
  c.stack[[i]] <- v*dclasses[[i]]
}




#------------------ aggregation to 8x8 and rounding ---------------------------------------------

pxIds<-raster("~/LEF/Dottorato/Case_studies/Chalara/Data/Ash_distribution/FFSM_input/Kriging/Results/Output_ordkrig/pxIds.grd")
projection(pxIds)<- CRS("+init=epsg:3035")


#generate 8x8 raster

b_hf8x8<-aggregate(extend(b_hf.stack,pxIds), fact=8, fun=sum, expand=TRUE, na.rm=TRUE)
names(b_hf8x8) <- c('dc15','dc25','dc35','dc45','dc55','dc65','dc75','dc85','dc95','dc150')

writeRaster(round(b_hf8x8), "~/LEF/Dottorato/Case_studies/Chalara/Data/Ash_distribution/FFSM_input/FINAL/KED/broad_high_forest/b_hf.asc", format="ascii", bylayer=TRUE,  datatype="INT2U",overwrite=TRUE)




b_hfcp8x8<-aggregate(extend(b_hfcp.stack,pxIds), fact=8, fun=sum, expand=TRUE, na.rm=TRUE)
names(b_hfcp8x8) <- c('dc15','dc25','dc35','dc45','dc55','dc65','dc75','dc85','dc95','dc150')

writeRaster(round(b_hfcp8x8), "~/LEF/Dottorato/Case_studies/Chalara/Data/Ash_distribution/FFSM_input/FINAL/KED/broad_high_forest_coppice/b_hfcp.asc", format="ascii", bylayer=TRUE,  datatype="INT2U", overwrite=TRUE)



b_cp8x8<-aggregate(extend(b_cp.stack,pxIds), fact=8, fun=sum, expand=TRUE, na.rm=TRUE)
names(b_cp8x8) <- c('dc15','dc25','dc35','dc45','dc55','dc65','dc75','dc85','dc95','dc150')

writeRaster(round(b_cp8x8), "~/LEF/Dottorato/Case_studies/Chalara/Data/Ash_distribution/FFSM_input/FINAL/KED/broad_coppice/b_cp.asc", format="ascii", bylayer=TRUE,  datatype="INT2U", overwrite=TRUE)


c8x8<-aggregate(extend(c.stack,pxIds), fact=8, fun=sum, expand=TRUE, na.rm=TRUE)
names(c8x8) <- c('dc15','dc25','dc35','dc45','dc55','dc65','dc75','dc85','dc95','dc150')

writeRaster(round(c8x8), "~/LEF/Dottorato/Case_studies/Chalara/Data/Ash_distribution/FFSM_input/FINAL/KED/conifers/c.asc", format="ascii", bylayer=TRUE,  datatype="INT2U", overwrite=TRUE)

